/*
 *  KernelEx
 *  Copyright (C) 2008, Xeno86
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _USER32_APILIST_H
#define _USER32_APILIST_H

#include "kexcoresdk.h"

/* There is no GetAltTabInfoA or RealGetWindowClassA in 9x */
#ifdef GetAltTabInfo
#undef GetAltTabInfo
#endif
EXTERN_C BOOL WINAPI GetAltTabInfo(HWND,int,PVOID,LPSTR,UINT);
#ifdef RealGetWindowClass
#undef RealGetWindowClass
#endif
EXTERN_C UINT WINAPI RealGetWindowClass(HWND  hwnd, LPTSTR pszType, UINT  cchType);


typedef BOOL (WINAPI *IsHungThread_t)(DWORD ThreadID);
extern IsHungThread_t IsHungThread_pfn;
typedef BOOL (WINAPI *DrawCaptionTempA_t)(HWND, HDC, const RECT*, HFONT, HICON, LPCSTR, UINT);
extern DrawCaptionTempA_t DrawCaptionTempA_pfn;
typedef int (WINAPI *GetMouseMovePoints_t)(UINT,LPMOUSEMOVEPOINT,LPMOUSEMOVEPOINT,int,DWORD);
extern GetMouseMovePoints_t GetMouseMovePoints_pfn;

BOOL init_user32();
extern const apilib_api_table apitable_user32;

/*** AUTOGENERATED APILIST DECLARATIONS BEGIN ***/

// user32\DisableProcessWindowsGhosting.c
void __stdcall DisableProcessWindowsGhosting_new(void);

// user32\EnableWindow.c
BOOL WINAPI EnableWindow_fix(HWND hWnd, BOOL bEnable);

// user32\ForegroundWindow.c
BOOL WINAPI AllowSetForegroundWindow_98(DWORD procid);
BOOL WINAPI LockSetForegroundWindow_98(UINT lockcode);

// user32\GetAncestor.c
HWND APIENTRY GetAncestor_fix(HWND hwnd, UINT gaFlags);

// user32\GetMouseMovePointsEx.c
int WINAPI GetMouseMovePointsEx_98(UINT size, LPMOUSEMOVEPOINT ptin, LPMOUSEMOVEPOINT ptout, int count, DWORD res);

// user32\GetNextDlgTabItem_fix.c
HWND WINAPI GetNextDlgTabItem_fix(HWND hDlg, HWND hCtl, BOOL bPrevious);

// user32\IsHungAppWindow.c
BOOL WINAPI IsHungAppWindow_new(HWND hWnd);

// user32\LockWorkStation.c
BOOL WINAPI LockWorkStation_new(void);

// user32\MapVirtualKey_fix.c
UINT WINAPI MapVirtualKeyA_new(UINT uCode, UINT uMapType);
UINT WINAPI MapVirtualKeyExA_new(UINT uCode, UINT uMapType, HKL dwhkl);

// user32\Menu.c
HMENU WINAPI LoadMenuA_fix(HINSTANCE hInstance, LPCSTR lpMenuName);
HMENU WINAPI LoadMenuW_new(HINSTANCE hInstance, LPCWSTR lpMenuNameW);
BOOL WINAPI InsertMenuW_new(HMENU hMenu, UINT uPosition, UINT uFlags, UINT_PTR uIDNewItem, LPCWSTR lpNewItemW);
BOOL WINAPI AppendMenuW_new(HMENU hMenu, UINT uFlags, UINT_PTR uIDNewItem, LPCWSTR lpNewItem);
BOOL WINAPI ChangeMenuW_new(HMENU hMenu, UINT cmd, LPCWSTR lpNewItemW, UINT uIDNewItem, UINT uFlags);
BOOL WINAPI ModifyMenuW_new(HMENU hMenu, UINT uPosition, UINT uFlags, UINT_PTR uIDNewItem, LPCWSTR lpNewItemW);

// user32\RawInput.c
LRESULT WINAPI DefRawInputProc_new(PVOID paRawInput, INT nInput, UINT cbSizeHeader);
UINT WINAPI GetRawInputBuffer_new(PVOID pData, PUINT pcbSize, UINT cbSizeHeader);
UINT WINAPI GetRawInputData_new(PVOID hRawInput, UINT uiCommand, LPVOID pData, PUINT pcbSize, UINT cbSizeHeader);
UINT WINAPI GetRawInputDeviceList_new(PVOID pRawInputDeviceList, PUINT puiNumDevices, UINT cbSize);
UINT WINAPI GetRawInputDeviceInfo_new(HANDLE hDevice, UINT uiCommand, LPVOID pData, PUINT pcbSize);
UINT WINAPI GetRegisteredRawInputDevices_new(PVOID pRawInputDevices, PUINT puiNumDevices, UINT cbSize);
BOOL WINAPI RegisterRawInputDevices_new(PVOID pRawInputDevices, UINT uiNumDevices, UINT cbSize);

// user32\SendMessage_fix.c
LRESULT WINAPI SendMessageA_fix(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);

// user32\SetParent_fix.c
HWND WINAPI SetParent_fix(HWND hWndChild, HWND hWndNewParent);

// user32\SystemParametersInfo_fix.c
BOOL WINAPI SystemParametersInfoA_fix(UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni);

// user32\UpdateLayeredWindow.c
BOOL WINAPI UpdateLayeredWindow_new(HWND hwnd, HDC hdcDst, POINT *pptDst, SIZE *psize, HDC hdcSrc, POINT *pptSrc, COLORREF crKey, BLENDFUNCTION *pblend, DWORD dwFlags);

// user32\WCSToMBEx.c
DWORD WINAPI WCSToMBEx_new (WORD CodePage, LPWSTR UnicodeString, LONG UnicodeSize, LPSTR *MBString, LONG MBSize, BOOL Allocate);
DWORD WINAPI MBToWCSEx_new (WORD CodePage, LPSTR MBString, LONG MBSize, LPWSTR *UnicodeString, LONG UnicodeSize, BOOL Allocate);

// user32\_user32_apilist.c

// user32\_user32_stubs.c
STUB PrintWindow_stub;
STUB SetLayeredWindowAttributes_stub;
STUB CalcMenuBar_stub;
STUB ChangeWindowMessageFilter_stub;
STUB CliImmSetHotKey_stub;
STUB GetLayeredWindowAttributes_stub;
STUB GetWindowRgnBox_stub;
STUB InitSharedTable_stub;
STUB IsServerSideWindow_stub;
STUB IsWinEventHookInstalled_stub;
STUB IsWindowInDestroy_stub;
STUB RegisterPowerSettingNotification_stub;
STUB RegisterServicesProcess_stub;
STUB SetProcessDPIAware_stub;
STUB SetProcessDPIAware1_stub;
STUB UnregisterPowerSettingNotification_stub;
STUB User32InitializeImmEntryTable_stub;
STUB UserHandleGrantAccess_stub;
STUB UserRealizePalette_stub;
STUB GetAppCompatFlags_stub;
STUB GetAppCompatFlags2_stub;
STUB InitializeLpkHooks_stub;
STUB UpdatePerUserSystemParameters_stub;
STUB KillSystemTimer_stub;
STUB SetSystemTimer_stub;
STUB RegisterUserApiHook_stub;
STUB UnregisterUserApiHook_stub;
STUB PaintMenuBar_stub;
STUB GetCursorFrameInfo_stub;

// user32\lstr.c
LPCWSTR WINAPI CharNextExW_new(WORD codepage, LPCWSTR ptr, DWORD flags);
LPCWSTR WINAPI CharNextW_new(LPCWSTR ptr);
LPCWSTR WINAPI CharPrevExW_new(WORD codepage, LPCWSTR start, LPCWSTR ptr, DWORD flags);
LPCWSTR WINAPI CharPrevW_new(LPCWSTR start, LPCWSTR ptr);
BOOL WINAPI CharToOemBuffW_new(LPCWSTR lpszSrc, LPSTR lpszDst, DWORD len);
BOOL WINAPI CharToOemW_new(LPCWSTR s, LPSTR d);
BOOL WINAPI OemToCharBuffW_new(LPCSTR s, LPWSTR d, DWORD len);
BOOL WINAPI OemToCharW_new(LPCSTR s, LPWSTR d);
LPWSTR WINAPI CharLowerW_new(LPWSTR x);
LPWSTR WINAPI CharUpperW_new(LPWSTR x);
DWORD WINAPI CharLowerBuffW_new(LPWSTR str, DWORD len);
DWORD WINAPI CharUpperBuffW_new(LPWSTR str, DWORD len);
BOOL WINAPI IsCharLowerW_new(WCHAR x);
BOOL WINAPI IsCharUpperW_new(WCHAR x);
BOOL WINAPI IsCharAlphaNumericW_new(WCHAR x);
BOOL WINAPI IsCharAlphaW_new(WCHAR x);

// user32\misc.c

// user32\thuni_conv.c

// user32\thuni_layer.c
LONG WINAPI GetWindowLongA_fix(HWND hWnd, int nIndex);
BOOL WINAPI IsWindowUnicode_new(HWND hWnd);
LONG WINAPI SetWindowLongA_fix(HWND hWnd, int nIndex, LONG dwNewLong);
LONG WINAPI GetWindowLongW_new(HWND hWnd, int nIndex);
LONG WINAPI SetWindowLongW_new(HWND hWnd, int nIndex, LONG dwNewLong);
DWORD WINAPI GetClassLongW_new(HWND hWnd, int nIndex);
DWORD WINAPI SetClassLongW_new(HWND hWnd, int nIndex, LONG dwNewLong);
ATOM WINAPI RegisterClassExW_new(CONST WNDCLASSEXW *lpwcx);
ATOM WINAPI RegisterClassW_new(CONST WNDCLASSW *lpwcx);
ATOM WINAPI GetClassInfoExW_new(HINSTANCE hinst, LPCWSTR lpszClass, WNDCLASSEXW *lpwcx);
ATOM WINAPI GetClassInfoW_new(HINSTANCE hinst, LPCWSTR lpszClass, WNDCLASSW *wc);
HWND WINAPI CreateWindowExW_new(DWORD dwExStyle, LPCWSTR lpClassName, LPCWSTR lpWindowName, DWORD dwStyle, int x, int y, int nWidth, int nHeight, HWND hWndParent, HMENU hMenu, HINSTANCE hInstance, LPVOID lpParam);
HWND WINAPI CreateWindowW_new(LPCWSTR lpClassName, LPCWSTR lpWindowName, DWORD dwStyle, int x, int y, int nWidth, int nHeight, HWND hWndParent, HMENU hMenu, HINSTANCE hInstance, LPVOID lpParam);
HWND WINAPI CreateMDIWindowW_new(LPCWSTR lpClassName, LPCWSTR lpWindowName, DWORD dwStyle, int X, int Y, int nWidth, int nHeight, HWND hWndParent, HINSTANCE hInstance, LPARAM lParam);
HWND WINAPI CreateDialogParamW_new(HINSTANCE hInstance, LPCTSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
HWND WINAPI CreateDialogIndirectParamW_new(HINSTANCE hInstance, LPCDLGTEMPLATE lpTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM lParamInit);
INT_PTR WINAPI DialogBoxParamW_new(HINSTANCE hInstance, LPCWSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
INT_PTR WINAPI DialogBoxIndirectParamW_new(HINSTANCE hInstance, LPCDLGTEMPLATE hDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
LRESULT WINAPI SendMessageW_new(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI DefWindowProcW_new(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
BOOL WINAPI SetWindowTextW_new(HWND hWnd, LPCWSTR lpString);
BOOL WINAPI SetDlgItemTextW_new(HWND hDlg, int nIDDlgItem, LPCWSTR lpString);
LRESULT WINAPI SendDlgItemMessageW_new(HWND hDlg, int nIDDlgItem, UINT Msg, WPARAM wParam, LPARAM lParam);
int WINAPI GetWindowTextW_new(HWND hWnd, LPWSTR lpString, int nMaxCount);
int WINAPI GetDlgItemTextW_new(HWND hDlg, int nIDDlgItem, LPWSTR lpString, int nMaxCount);
int WINAPI GetWindowTextLengthW_new(HWND hWnd);
BOOL WINAPI UnregisterClassW_new(LPCWSTR lpClassName, HINSTANCE hInstance);
BOOL WINAPI SendMessageCallbackW_new(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam, SENDASYNCPROC lpCallBack, DWORD dwData);
LRESULT WINAPI SendMessageTimeoutW_new(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam, UINT fuFlags, UINT uTimeout, LPDWORD lpdwResult);

// user32\thuni_proc.c
LRESULT WINAPI CallWindowProcA_fix(WNDPROC lpPrevWndFunc, HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI CallWindowProcW_new(WNDPROC lpPrevWndFunc, HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI DefDlgProcW_new(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI DefMDIChildProcW_new(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI PostMessageW_new(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI SendNotifyMessageW_new(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI PostThreadMessageW_new(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI DefFrameProcW_new(HWND hWnd, HWND hWndMDIClient, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL WINAPI GetMessageA_fix(LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax);
BOOL WINAPI PeekMessageA_fix(LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax, UINT wRemoveMsg);
BOOL WINAPI GetMessageW_new(LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax);
BOOL WINAPI PeekMessageW_new(LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax, UINT wRemoveMsg);
BOOL WINAPI GetLastInputInfo_new(PLASTINPUTINFO plii);
int WINAPI ToUnicodeEx_new(UINT wVirtKey, UINT wScanCode, const PBYTE lpKeyState, LPWSTR pwszBuff, int cchBuff, UINT wFlags, HKL dwhkl);
int WINAPI ToUnicode_new(UINT wVirtKey, UINT wScanCode, const PBYTE lpKeyState, LPWSTR pwszBuff, int cchBuff, UINT wFlags);

// user32\thuni_stuff.c

// user32\thuni_thunk.c

// user32\uniuser32.c
BOOL WINAPI DrawCaptionTempW_new(HWND hwnd, HDC hdc, const RECT *rect, HFONT hFont, HICON hIcon, LPCWSTR strW, UINT uFlags);
int WINAPI LoadStringW_new(HINSTANCE hInstance, UINT uID, LPWSTR lpBuffer, int nBufferMax);
UINT WINAPI RealGetWindowClassW_new(HWND hwnd, LPWSTR pszTypeW, UINT cchType);

#define user32_ordinal_apis NULL
/*** AUTOGENERATED APILIST DECLARATIONS END ***/

#endif
